import torch
import torchvision
from torchvision import transforms

from config import cfg

def get_cifar10():
    '''
        get dataloader
    '''
    print('==> Preparing Cifar10 data..')
    transform_train = transforms.Compose([
        transforms.RandomCrop(32, padding=4),
        transforms.RandomHorizontalFlip(),
        transforms.ToTensor(),
        transforms.Normalize((0.4914, 0.4822, 0.4465), (0.247, 0.243, 0.261)),
    ])

    transform_test = transforms.Compose([
        transforms.ToTensor(),
        transforms.Normalize((0.4914, 0.4822, 0.4465), (0.247, 0.243, 0.261)),
    ])

    trainset = torchvision.datasets.CIFAR10(root='./data/pytorch', train=True, download=True, transform=transform_train)
    train_loader = torch.utils.data.DataLoader(
        trainset, batch_size=cfg.data.batch_size, shuffle=cfg.data.shuffle, num_workers=8)

    testset = torchvision.datasets.CIFAR10(root='./data/pytorch', train=False, download=True, transform=transform_test)
    test_loader = torch.utils.data.DataLoader(
        testset, batch_size=cfg.data.test_batch_size, shuffle=False, num_workers=8)

    return train_loader, test_loader
