function index = extract_comp(pair_adj, seed)
%extract a connected component for analysis
    n = max(pair_adj(:));
    flag = zeros(n,1);
    flag(seed) = 1;
    myq = [seed];
    index = [seed];
    while length(myq) > 0,
        temp = myq(1);
        myq(1) = [];
        pos = find(pair_adj(:, 1) == temp);
        newpos = find(flag(pair_adj(pos, 2)) == 0);
        flag(pair_adj(pos, 2)) = 1;
        templist = (pair_adj(pos(newpos), 2))';
        myq = [myq templist];
        index = [index templist];
    end
end