package solver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import base.Point;
import clust.Clustering;
import clust.Objective;
import clust.WeightedPoint;

public class ClusteringSolver
{
    public static ArrayList<Point> localSearch(ArrayList<WeightedPoint> X, int k, Objective O)
    {
        HashSet<Integer> remain = new HashSet<Integer>();
        HashSet<Integer> sol = new HashSet<Integer>();
        List<Point> fX = WeightedPoint.flatten(X);

        for (int i = 0; i < k; i++)
        {
            sol.add(i);
        }

        ArrayList<Point> C = new ArrayList<Point>();
        getData(fX, sol, C);
        double current = Clustering.evaluate(X, C, O);
        while (true)
        {
            boolean flag = false;
            int del = 0, ins = 0;
            for (Integer i : remain)
            {
                if (flag) break;
                for (Integer j : sol)
                {
                    // swap: + i - j
                    C.clear();
                    C.add(fX.get(i));
                    for (Integer t : sol)
                    {
                        if (!t.equals(j))
                        {
                            C.add(fX.get(t));
                        }
                    }
                    double tmp = Clustering.evaluate(X, C, O);
                    if (tmp < current)
                    {
                        current = tmp;
                        flag = true;
                        ins = i;
                        del = j;
                        break;
                    }
                }
            }
            if (!flag) return C;
            sol.remove(del);
            sol.add(ins);
            remain.remove(ins);
            remain.add(del);
        }
    }

    private static void getData(List<Point> X, Set<Integer> S, List<Point> C)
    {
        C.clear();
        for (Integer t : S)
        {
            C.add(X.get(t));
        }
    }
}
