package coreset;

import java.util.ArrayList;
import java.util.List;

import base.Line;
import base.Point;
import clust.Objective;
import clust.WeightedDouble;
import clust.WeightedPoint;

public abstract class Coreset1D
{
	protected Segment data;
	protected List<Point> optCenters;
	protected Coreset1D(List<WeightedPoint> pointSet, Line line, List<Point> optCenters)
	{
		data = new Segment(pointSet, line);
		this.optCenters = optCenters;
	}
	
	public boolean isEmpty()
	{
		return data.T.isEmpty();
	}

	protected abstract double evaluateError(double start, double end);
	private Segment generateSegment(double start, double end)
	{
		List<WeightedDouble> list = WeightedDouble.fracSubList(data.T, start, end);
		Segment res = new Segment(data.line);
		res.T.addAll(list);
		res.sort();
		return res;
	}
	protected abstract double getThreshold(double eps, int k, double opt);
	protected abstract Objective getObjective();
	
	private ArrayList<Segment> segmentation(int s, int t, double eps, int k, double opt)
	{
		double threshold = getThreshold(eps, k, opt);
		ArrayList<Segment> res = new ArrayList<Segment>();
		int start = s;
		while (t - start > 1)
		{
			double a = start;
			double b = t;
			double sol = b;
			if (evaluateError(start, t) <= threshold)
			{
				res.add(generateSegment(start, t));
				start = t;
				break;
			}
			while (b - a > 1e-4)
			{
				double mid = (a + b) / 2.0;
				if (evaluateError(start, mid) <= threshold)
				{
					sol = mid;
					a = mid;
				}
				else
				{
					b = mid;
				}
			}
			sol = Math.floor(sol);
			res.add(generateSegment(start, sol));
			start = (int)sol;
		}
		if (start != t)
			res.add(generateSegment(start, t));
		//Segment last = new Segment(data.center, data.direction);
		//last.T.add(data.T.get(t));
		//res.add(last);
		//if (res.size() == 0)
		//{
		//	System.out.println("here1");
		//}
		return res;
	}
	
	public Segment getSegment()
	{
		return this.data;
	}

	public ArrayList<Segment> getSegments(double eps, int k)
	{
		double hopt = 0;
		ArrayList<WeightedPoint> pnt = data.toPoints();
		for (WeightedPoint P : pnt)
		{
			hopt += P.weight * getObjective().value(Point.dist(P.data, optCenters));
		}
		return segmentation(0, data.T.size(), eps, k, hopt);
	}
}
