import torch
import torch.nn.functional as F
from torch.autograd import Variable
from core import metrics
import numpy as np


def logmeanexp(x, dim=None, keepdim=False):
    """Stable computation of log(mean(exp(x))"""
    if dim is None:
        x, dim = x.view(-1), 0
    xm, _ = torch.max(x, dim, keepdim=True)
    x = xm + torch.log(torch.mean(torch.exp(x - xm), dim, keepdim=True))
    return x if keepdim else x.squeeze(dim)


def adjust_learning_rate(optimizer, lr):
    """Manually set the learning rate for optimizer"""
    for param_group in optimizer.param_groups:
        param_group['lr'] = lr


def lr_linear(epoch_num, decay_start, total_epochs, start_value):
    if epoch_num < decay_start:
        return start_value
    return start_value*float(total_epochs-epoch_num)/float(total_epochs-decay_start)
