import os
import numpy as np

from tape.analysis import get_best_metric


if __name__ == '__main__':
    import matplotlib.pyplot as plt

    directories = ['results/bilm-no-pretrain',
                   'results/2019-04-10--11-10-05_bilm_pfam31_whole/',
                   'results/resnet-no-pretrain',
                   'results/resnet-no-pretrain-big',
                   'results/transformer-no-pretrain',
                   'results/2019-04-11--14-23-37_bert_pfam31_whole/',
                   'results/snail-no-pretrain']

    supervised = ['secondary_structure', 'transmembrane', 'gfp3', 'thermostability', 'localization']

    results = {
        directory.split('/')[1]:
        [get_best_metric(os.path.join(directory, 'supervised', task)) for task in supervised]
        for directory in directories}

    fig, ax = plt.subplots()
    index = np.arange(len(supervised))
    bar_width = 1 / (len(directories) + 1)

    for i, (directory, values) in enumerate(results.items()):
        ax.bar(index + i * bar_width, values, bar_width, label=directory)

    ax.set_xlabel('Task')
    ax.set_ylabel('Validation')
    ax.set_xticks(index + bar_width / 2)
    ax.set_xticklabels(supervised)
    ax.legend()

    plt.show()
