#!/usr/bin/env bash

# Copyright 2019 The MixMatch Authors.  All rights reserved.

echo "# Ablation study, we're using seed 3 (which we found to be the hardest one for CIFAR10)"
echo "# Using default options:  --wd=0.02 --filters=32"
for size in 250 4000; do
    common_args="--dataset=cifar10.3@${size}-1 --train_dir experiments/ablation --beta=0.75"
    echo "python ablation/ab_mixmatch.py $common_args  # Standard MixMatch"
    echo "python ablation/ab_mixmatch.py $common_args --nu=1  # No consistency"
    echo "python ablation/ab_mixmatch.py $common_args --T=1  # No sharpening"
    echo "python ablation/ab_mixmatch.py $common_args --use_ema_guess  # EMA guess"
    echo "python ablation/ab_mixmatch.py $common_args --mixmode=.  # No mixup"
    echo "python ablation/ab_mixmatch.py $common_args --mixmode=xx.  # Only mixup labeled"
    echo "python ablation/ab_mixmatch.py $common_args --mixmode=.yy  # Only mixup unlabeled"
    echo "python ablation/ab_mixmatch.py $common_args --mixmode=xx.yy  # Mixup labeled and unlabeled separately"
    echo "python ict.py $common_args --consistency_weight=1000  # ICT"
    echo
done

