import  numpy as np
import os
import torch
import h5py

def processRaw(N,rawdir):
    A_train=[]
    A_test=[]
    for i in range(1,N):
        print(i)
        fname=rawdir+'raw/HS-SOD/hyperspectral/'+str(i).zfill(4)+'.mat'
        if os.path.exists(fname):
            f = h5py.File(fname, 'r')
            AList=f['hypercube'][:]
            for j in range(AList.shape[0]):
                As = torch.from_numpy(AList[j]).view(AList[j].shape[0], -1).float()
                # print(As.size())
                U, S, V = As.svd()
                div = abs(S[0].item())
                if div < 1e-10:
                    div = 1
                    print("Catch!")
                div /= 100
                if np.random.random()<0.8:
                    A_train.append(As/div)
                else:
                    A_test.append(As/div)

    torch.save([A_train,A_test],rawdir+"raw/hyper_"+str(N)+".dat")
def getHyper(raw,N,rawdir):
    if N<0:
        N=5
    if raw:
        processRaw(N,rawdir)
    A_train,A_test=torch.load(rawdir+"raw/hyper_"+str(N)+".dat")
    return A_train,A_test, A_train[0].shape[0], A_train[0].shape[1]
