import calc_frechet
import numpy as np
import pandas as pd
import sys
import json
import time
from sklearn.decomposition import PCA

if len(sys.argv) < 2:
	epsilon = 0.4
	
else:
	epsilon = float(sys.argv[1])

k = int(np.ceil(2 * np.log(2 * 2205) * 1/(epsilon*epsilon)))


data1 = np.random.dirichlet((1,) * 6001, 2205) * 1e7
data2 = np.random.dirichlet((1,) * 6001, 2205) * 1e7

data1 = np.delete(data1, data1.shape[len(data1.shape)-1]-1, 1)
data2 = np.delete(data2, data2.shape[len(data2.shape)-1]-1, 1)

d1 = calc_frechet.Curve(data1)
d2 = calc_frechet.Curve(data2)

l = len(data1)

start = time.clock()

pca = PCA(n_components=k)
data = pca.fit_transform(np.concatenate((data1, data2)))

end = time.clock()

d1_pca = calc_frechet.Curve(data[:l])
d2_pca = calc_frechet.Curve(data[l:])

distance_rp = calc_frechet.calculate_distance_parallel(d1_pca, d2_pca)
distance = calc_frechet.calculate_distance_parallel(d1, d2)

dump = {
	'data': {
        'method': 'pca',
        'methodtime': end-start,
		'names': ["random simplex", "random simplex"],
		'lengths': [data[:l].shape[0], data[l:].shape[0]],
		'dimensions': [data[:l].shape[1], data[l:].shape[1]],
		'epsilon': epsilon,
	},
	'rp': {
			'rt_b': distance_rp.time_bounds,
			'rt_s': distance_rp.time_searches,
			'n_s': distance_rp.number_searches,
			'value': distance_rp.value,
    },
    'nrp': {
			'rt_b': distance.time_bounds,
			'rt_s': distance.time_searches,
			'n_s': distance.number_searches,
			'value': distance.value,
    },
}

print(json.dumps(dump))
