import calc_frechet
import numpy as np
import pandas as pd
import sys
import json
import time
from sklearn import random_projection

if len(sys.argv) < 4:
    epsilon = 0.1
    gamma = 10
    d = 6000
else:
    epsilon = float(sys.argv[1])
    gamma = float(sys.argv[2])
    d = int(sys.argv[3])

dp = int(np.ceil(4 * np.log(5)*1/(epsilon*epsilon/2 - epsilon*epsilon*epsilon/3)))

p1 = np.zeros((d,))

p2 = np.zeros((d,))
p2[0] = gamma

q1 = np.zeros((d,))
q1[1] = 1

q2 = np.zeros((d,))
q2[0] = gamma/2
q2[1] = 2
q2[2] = 1

q3 = np.zeros((d,))
q3[0] = gamma
q3[1] = 1

p = np.zeros((2, d))
p[0,:] = p1
p[1,:] = p2

q = np.zeros((3, d))
q[0, :] = q1
q[1, :] = q2
q[2, :] = q3


transformer = random_projection.GaussianRandomProjection(n_components=dp)
data = transformer.fit_transform(np.concatenate((p, q)))

d1 = calc_frechet.Curve(data[:2])
d2 = calc_frechet.Curve(data[2:])

distance = calc_frechet.calculate_distance_parallel(d1, d2)

dump = {
    'data': {
        'lengths': [data[:2].shape[0], data[2:].shape[0]],
        'dimensions': [data[:2].shape[1], data[2:].shape[1]],
        'epsilon': epsilon,
        'gamma': gamma,
    },
    'rp': {
        'rt_b': distance.time_bounds,
        'rt_s': distance.time_searches,
        'n_s': distance.number_searches,
        'value': distance.value,
    },
}

print(json.dumps(dump))
