import calc_frechet
import numpy as np
import pandas as pd
import sys

if len(sys.argv) < 5:
	pers1 = "p1"
	pers2 = "p2"
	act1 = "a01"
	act2 = "a02"
	
else:
	pers1 = sys.argv[3]
	pers2 = sys.argv[4]
	act1 = sys.argv[1]
	act2 = sys.argv[2]

def import_from_txt(path):
    data = pd.read_csv(path, sep=",", header=None)
    return data

#Import the data

name1 = "../data/data/{}/{}/all.txt".format(act1, pers1)
name2 = "../data/data/{}/{}/all.txt".format(act2, pers2)

data1 = import_from_txt(name1)
data2 = import_from_txt(name2)

print("using data {} {}".format(name1, name2))

data_np_array1 = data1.values
data_np_array2 = data2.values
data_np_array1 = np.array(data_np_array1, dtype="d")
data_np_array2 = np.array(data_np_array2, dtype="d")

d1 = calc_frechet.Curve(data_np_array1)
d2 = calc_frechet.Curve(data_np_array2)

d = calc_frechet.Curves()

d.add(d1)
d.add(d2)

drp = calc_frechet.jl_transform(d, 0.4)

distance = calc_frechet.calculate_distance(d[0], d[1])
print("FRECHET DISTANCE IS: " + str(distance))

distance_rp = calc_frechet.calculate_distance(drp[0], drp[1])
print("FRECHET DISTANCE IS: " + str(distance_rp) + " rp")

#a = np.array([[0.0],[1.0]], dtype="d")
#b = np.array([[0.0],[2.0]], dtype="d")

#ac = calc_frechet.Curve(a)
#bc = calc_frechet.Curve(b)

#distance = calc_frechet.calculate_distance(ac, bc)
#print("FRECHET DISTANCE IS: " + str(distance))

#a = np.array([[0.0],[1.0], [0.0], [1.0]], dtype="d")
#b = np.array([[0.0],[0.75], [0.25], [1.0]], dtype="d")
#c = np.array([[0.0],[1.0]], dtype="d") # distanz zu a = 0.5, distanz zu b = 0.25
#ac = calc_frechet.Curve(a)
#bc = calc_frechet.Curve(b)
#cc = calc_frechet.Curve(c)

#distance = calc_frechet.calculate_distance(ac, bc)
#distance2 = calc_frechet.calculate_distance(ac, cc)
#print("FRECHET DISTANCE IS: " + str(distance))
#print("FRECHET DISTANCE IS: " + str(distance2))
