import numpy
import random
import time
import os
import matplotlib.pyplot as plt
import datasets
import models
import sys
import pickle

MOVIELENS_STEP_SIZE = 5e-3
MOVIELENS_MU = 1e-1
A9A_STEP_SIZE = 5e-3
A9A_MU = 1e-3
RCV_STEP_SIZE = 5e-1
RCV_MU = 1e-5

def process(M, train_set, test_set, b, arrivals, rho, init_w, opt, step_size, mu):
    loss = {
                'Inc': {'test': [0]*b, 'subopt': [0]*b},
                'sample': [0]*b
           }
    
    S = 0    # S_i = train_data[0:S]
    S_prev = 0
    
    TI = 0   # for STRSAGA, the sample set is train_set[0:TI]
    TA = 0   # Algo A samples from train_set[0:TA]
    wI = models.LogisticRegression(init_w, opt)
    wA = models.LogisticRegression(init_w, opt)
    trainI = 0
    trainA = 0
    
    loss['Inc']['subopt'][0] = 0
    loss['Inc']['test'][0] = wI.loss(test_set)
    loss['sample'][0] = 1
    
    for time in xrange(1, b):
        S_prev = S
        S += (M if (random.random() < 1.0*arrivals/M) else 0)
        if S > len(train_set):
            S = len(train_set)

        if S != 0:
            # Algo I
            for s in xrange(rho):
                if (s % 2 == 0 and TI < S):
                    j = TI
                    TI += 1
                else:
                    j = random.randrange(TI)
                wI.update_step(train_set[j], step_size, mu)
            trainI = wI.reg_loss(train_set[:S], mu)
                
            # Algo A
            if S != S_prev:
                wA = models.LogisticRegression(init_w, opt)
                TA = 0
                for s in xrange(30*S):
                    if (s % 2 == 0 and TA < S):
                        j = TA
                        TA += 1
                    else:
                        j = random.randrange(TA)
                    wA.update_step(train_set[j], step_size, mu)
                trainA = wA.reg_loss(train_set[:S], mu)
        
        TB = min(rho*time/2, S)
        
        loss['Inc']['subopt'][time] = trainI - trainA
        loss['Inc']['test'][time] = wI.loss(test_set)
        loss['sample'][time] = 1.0 * TI / TB if TB != 0 else 1
                
    return loss

if __name__ == "__main__":
    train_data, test_data, d = datasets.rcv()
    init_w = numpy.random.rand(d)
    opt = models.Opt.SAGA
    b = 100
    
    if len(sys.argv) < 3:
        rate = 10 
        k = 3       # prob of arrival is 1/(2^k)
    else:
        rate = float(sys.argv[1])
        k = int(sys.argv[2])
        
    name = 'rcv-r{0}_m{1}'.format(rate, k)
   
    arrivals = len(train_data)/(2*b) 
    rho = int(arrivals * rate)
    if rho % 2 != 0:
        rho += 1
    M = arrivals * (1 << k)
    
    N = 9
    outputs = []
    for i in xrange(N):
        output = process(M, train_data, test_data, b, arrivals, rho, init_w, opt, 
                     step_size=RCV_STEP_SIZE, mu=RCV_MU)
        outputs.append(output)
    
    with open('output/output_data/{0}.pkl'.format(name), 'w') as f:
        pickle.dump(outputs, f)
