function [C, leftClusters] = message_wrapper(inputFile,k,p_x_1,p_y_1,p_0_given_0,p_1_given_1)
	pythonPath = SETUP_matlab('SETUP_PYTHON_PATH');
	pythonFile = SETUP_matlab('SETUP_MESSAGE_PATH');
	outFile = tempname();
	clusterOutputFile = tempname();


	call = [pythonPath ' ' pythonFile ' -i ' inputFile ' -o ' outFile ' -k ' int2str(k) ' --p_x_1 ' num2str(p_x_1,3) ' --p_y_1 ' num2str(p_y_1,3) ' --p_0_given_0 ' num2str(p_0_given_0,3) ' --p_1_given_1 ' num2str(p_1_given_1,3) ' --clusterOutputFile ' clusterOutputFile ];
	[status result] = unix(call);

	if status ~= 0
		error(['message returned an error code ' int2str(status) ' with text ' result]);
	end

	C = readFileIfExists( outFile );
	leftClusters = readFileIfExists(clusterOutputFile);
	
	delete(outFile)
	delete(clusterOutputFile)
end

function [ C ] = readFileIfExists(outFile)
	nonemptyOutfile = 0;
	if exist(outFile, 'file')
		fid = fopen(outFile);    
		line_ = fgets(fid);    
		if ~(isequal(line_, -1)) 
			nonemptyOutfile = 1;
		end
	end

	if nonemptyOutfile == 1
		C = csvread(outFile);
	else
		C = [];
	end
end

