function [figLeft, figRight, figTimes] = load_experiments(folder, xlabelString)
% runs the experiments for a directory like 'vary_l'

	global algos;
	%algos = {'asso', 'nassau', 'panda', 'pcv', 'message', 'lfm', 'lim'};
	algos = {'pcv', 'message', 'lfm', 'lim'};
	% algos = {'lim'};

	disp(['Running algos: ', algos])

	parameters = [];

	results = containers.Map();
	resultsLeft = containers.Map();
	ks = containers.Map();
	times = containers.Map();

	stdsQs = containers.Map();
	stdsQsLeft = containers.Map();
	stdsTimes = containers.Map();

	for algo = algos
		algochar = char(algo);
		results(algochar) = [];
		resultsLeft(algochar) = [];
		ks(algochar) = [];
		times(algochar) = [];

		stdsQs(algochar) = [];
		stdsQsLeft(algochar) = [];
		stdsTimes(algochar) = [];
	end

	files = dir(folder);
	for file = files'
		% skip hidden files
		if isequal(file.name, '.') | isequal(file.name, '..') | isequal(file.name, '.DS_Store') | isequal(file.name, 'results.mat') | isequal(file.name, 'figLeft.png') | isequal(file.name, 'figRight.png') | isequal(file.name, 'figTimes.png')
			continue
		end

		parameter = str2num(file.name)
		parameters = [parameters, parameter];

		[qs,qsLeft,cur_ks,cur_times,cur_stdsQs,cur_stdsQsLeft,cur_stdsTimes] = load_experiments_for_parameter( strcat(file.folder, filesep, file.name), parameter );

		for algo = algos
			algochar = char(algo);
			results(algochar) = [results(algochar), qs(algochar)];
			resultsLeft(algochar) = [resultsLeft(algochar), qsLeft(algochar)];
			ks(algochar) = [ks(algochar), cur_ks(algochar)];
			times(algochar) = [times(algochar), cur_times(algochar)];

			stdsQs(algochar) = [stdsQs(algochar), cur_stdsQs(algochar)];
			stdsQsLeft(algochar) = [stdsQsLeft(algochar), cur_stdsQsLeft(algochar)];
			stdsTimes(algochar) = [stdsTimes(algochar), cur_stdsTimes(algochar)];
		end
	end

	[parameters, I] = sort(parameters);
	for algo = algos
		algochar = char(algo);
		res = results(algochar);
		results(algochar) = res(I);

		resL = resultsLeft(algochar);
		resultsLeft(algochar) = resL(I);

		ks_unordered = ks(algochar);
		ks(algochar) = ks_unordered(I);

		times_unordered = times(algochar);
		times(algochar) = times_unordered(I);

		stdsQs_unordered = stdsQs(algochar);
		stdsQs(algochar) = stdsQs_unordered(I);

		stdsQsLeft_unordered = stdsQsLeft(algochar);
		stdsQsLeft(algochar) = stdsQsLeft_unordered(I);

		stdsTimes_unordered = stdsTimes(algochar);
		stdsTimes(algochar) = stdsTimes_unordered(I);
	end
	
	parameters

	figLeft = errorbar_algorithms(resultsLeft, parameters, stdsQsLeft, 'quality $Q$', xlabelString);
	figRight = errorbar_algorithms(results, parameters, stdsQs, 'quality $Q$', xlabelString);
	figTimes = errorbar_algorithms(times, parameters, stdsTimes, 'time (sec)', xlabelString);

	saveas(figLeft, strcat(folder, filesep, 'figLeft'), 'png');
	saveas(figRight, strcat(folder, filesep, 'figRight'), 'png');
	saveas(figTimes, strcat(folder, filesep, 'figTimes'), 'png');
end

function [qs,qsLeft,ks,times,stdsQs,stdsQsLeft,stdsTimes] = load_experiments_for_parameter(folder,param)
% runs the experiments for a given parameter, e.g., 'l = 30'
	num_runs = 0;

	global algos;
	qsTotal = containers.Map();
	qsLeftTotal = containers.Map();
	ksTotal = containers.Map();
	timesTotal = containers.Map();

	for algo = algos
		algochar = char(algo);
		qsTotal(algochar) = [];
		qsLeftTotal(algochar) = [];
		ksTotal(algochar) = [];
		timesTotal(algochar) = [];
	end

	files = dir(folder);
	for file = files'
		% skip hidden files
		if isequal(file.name, '.') | isequal(file.name, '..') | isequal(file.name, '.DS_Store')
			continue;
		end

		num_runs = num_runs + 1;

		exp_dir = strcat(file.folder, filesep, file.name);
		[cur_qs,cur_qsLeft, cur_ks,cur_time] = load_and_evaluate_experiments_from_folder(exp_dir,param);

		for algo = algos
			algochar = char(algo);
			qsTotal(algochar) = [qsTotal(algochar), cur_qs(algochar)];
			qsLeftTotal(algochar) = [qsLeftTotal(algochar), cur_qsLeft(algochar)];
			ksTotal(algochar) = [ksTotal(algochar), cur_ks(algochar)];
			timesTotal(algochar) = [timesTotal(algochar), cur_time(algochar)];
		end
	end

	qs = containers.Map();
	qsLeft = containers.Map();
	ks = containers.Map();
	times = containers.Map();

	stdsQs = containers.Map();
	stdsQsLeft = containers.Map();
	stdsTimes = containers.Map();
	stdFactor = 3;
	for algo = algos
		algochar = char(algo);
		qs(algochar) = mean(qsTotal(algochar));
		qsLeft(algochar) = mean(qsLeftTotal(algochar));
		ks(algochar) = mean(ksTotal(algochar));
		times(algochar) = mean(timesTotal(algochar));

		stdsQs(algochar) = std(qsTotal(algochar)) / stdFactor;
		stdsQsLeft(algochar) = std(qsLeftTotal(algochar)) / stdFactor;
		stdsTimes(algochar) = std(timesTotal(algochar)) / stdFactor;
	end
end

function[qs,qsLeft,ks,times] = load_and_evaluate_experiments_from_folder(folder,param)
	load( strcat(folder,filesep,'results'), 'qs', 'ks', 'Cs', 'times', 'CsLeft', 'qsLeft' );

	qs = qs;
	qsLeft = qsLeft;
	ks = ks;
	times = times;
end

