% Function used by simple_learn_obs_int

function f = simple_learn_obs_int_f(theta, XX, YY, K_prior, A)

sf2 = exp(theta(1));
ell = exp(theta(2));
likv = exp(theta(3));

K_f = K_prior + sf2 * exp(-0.5 * XX / ell);
K = A * K_f * A' + eye(length(YY)) * likv;

if sum(sum(isnan(K))) > 0
  f = Inf;
  return
end
if min(eig(K)) <= 0
  f = Inf;
  return
end

f = sum(log(eig(K))) + trace(K \ YY);
