% simple_learn_from_experiments:
%
% Given experimental data {X_train, Y_train}, fit a GP using marginal maximum likelihood.
%
% Input:
%
% - X_test: where to evaluate
% - X_train: train treatments
% - Y_train: train outcomes
%
% Output:
%
% - f_hat: evaluating of mean predictive function at test points

function f_hat = simple_learn_from_experiments(X_test, X_train, Y_train, num_iter) %#ok<INUSD>

f_hat = cell(2, 1);

covfuncs = cell(2, 1); hyp_covs = cell(2, 1);
covfuncs{1} = {@covMaterniso, 3}; hyp_covs{1} = zeros(2, 1);
covfuncs{2} = {@covSEiso};        hyp_covs{2} = zeros(2, 1);

for i = 1:2
  likfunc = @likGauss; %#ok<*NASGU>
  covfunc = covfuncs{i}; hyp.cov = hyp_covs{i}; hyp.lik = log(0.1);
  [~, hyp_baseline] = evalc('minimize(hyp, @gp, -num_iter, @infExact, [], covfunc, likfunc, X_train, Y_train)');
  K = feval(covfunc{:}, hyp_baseline.cov, X_train) + eye(length(X_train)) * exp(2 * hyp_baseline.lik);
  Ks = feval(covfunc{:}, hyp_baseline.cov, X_train, X_test);
  f_hat{i} = Ks' * (K \ Y_train);
end
