function basis = nonlinear_basis2(dat, x, z)

n = size(dat, 1);
dz = dat(:, z); log_dz = log(abs(dz));
Z_design = [dz dz.^2 log_dz log_dz .* dz log_dz .* dz.^2];
dx = dat(:, x); log_dx = log(abs(dx));
X_design = [dx dx.^2 log_dx log_dx .* dx log_dx .* dx.^2];
basis = [ones(n, 1) Z_design X_design dz .* dx dz .* log_dx log_dz .* dx dx.^3 dz.^3];
