% multi_exp_mapping:
%
% Maps relevant parameters based on experiments that might have taken place
% at the same treatment level several times.

function [A_exp, seen_exp, do_params_exp] = multi_exp_mapping(X_space, X_exp, X_obs, Z_obs, prior_info, verbose)

if nargin < 6
  verbose = false;
end

n = length(X_exp);
u_X_exp = unique(X_exp);
A_exp = zeros(n, length(u_X_exp));
for i = 1:length(u_X_exp)
  A_exp(X_exp == u_X_exp(i), i) = 1;
end

num_X_space = length(X_space);
seen_exp = zeros(num_X_space, 1);
for i = 1:num_X_space
  seen_exp(i) = ~isempty(find(u_X_exp == X_space(i), 1));
end

if nargout == 3
  do_params_exp = build_do_prekernel(u_X_exp, X_obs, Z_obs, prior_info, verbose);
end
