% batch_Z_sorting:
%
% This function sorts variables by order of confounding they introduce to
% the treatment/outcome pair, based on a give set of problems.
%
% Input:
%
% - path_input: directory containing the problem files (as generated by
%   "synth/generate_problems.m";
% - num_X_space: number of dose levels;
% - num_iter: number of iterations used in the optimization of the Gaussian 
%   processes;
% - verbose: whether to print output information.

function batch_Z_sorting(path_input, num_X_space, num_iter, verbose)

if nargin < 4, verbose = false; end
names = dir(strcat(path_input, '/problem*.mat'));

for i = 1:length(names)
    
  if verbose
    fprintf('     (PROBLEM %d) Going through file %s\n', i, names(i).name)
  end
  
  file_name = strcat(path_input, '/', names(i).name);
  load(file_name, 'dat', 'model')
  
  p = size(dat, 2) - 2; %#ok<NODEF>
  x = p + 1;
  y = p + 2;
  Z = 1:p;
  X_space = linspace(min(dat(:, x)), max(dat(:, x)), num_X_space)'; 
  f_space = zeros(num_X_space, 1);
  for j = 1:num_X_space
    [~, f_space(j)] = run_intervention(X_space(j), model);
  end

  Z_sorted_oracle = sort_covariates_oracle(dat, x, y, Z, num_iter, true, X_space, f_space, false); %#ok<NASGU>
  file_name = strcat(path_input, '/Z_sorting_', names(i).name);
  save(file_name, 'Z_sorted_oracle')
  
end
