%% SETUP FILE
%
% This is the first file that needs to be executed before everything. This
% will require the Gaussian Process for Machine Learning (GPML) library,
% available at http://www.gaussianprocess.org/gpml/code/matlab/doc/. 
%
% For experiments that involve running a standard Deep Gaussian Process, as
% used in the demo file "ihdp/run_ihdp.m", MATLAB Stan will be necessary. 
% It can be obtained from http://mc-stan.org/interfaces/matlab-stan.
% Notice that another piece of software, MATLAB Process Manager, will also
% be installed as part of this procedure. Stan (and Process Manager) are
% not necessary otherwise.

% SET PATHS: change GPML, Stan and ProcessManager paths (optional) 
% according to your own configuration. The below are examples.

GPML_PATH    = 'C:\Users\you\Documents\MATLAB\gpml';
STAN_PATH    = 'C:\Users\you\Documents\MATLAB\MatlabStan-2.7.0.0';
PROCMAN_PATH = 'C:\Users\you\Documents\MATLAB\ProcessManager';

% Tools

addpath(GPML_PATH); startup;
addpath(STAN_PATH)    % Optional, used by (parts of) "ihdp/run_ihdp.m"
addpath(PROCMAN_PATH) % Optional, used by (parts of) "ihdp/run_ihdp.m"

% Main directories

addpath('app')
addpath('debug')
addpath('design')
addpath('evaluate')
addpath('ihdp')
addpath('observational')
addpath('sample')
addpath('synth')
addpath('util')
