
function logpdf = hyper_seiso_logpdf(x, pos, params, f, mean_f, m_prior, v_prior, SD2, core, noise_matrix)

params(pos) = exp(x);
sf2 = params(1);
ell = params(2);
K = sf2 * SD2 .* exp(-0.5 * core / ell) + noise_matrix;
if min(eig(K)) <= 0
  logpdf = -Inf;
  return
end
f_c = f - mean_f;

logpdf = -(x - m_prior)^2 / v_prior - sum(log(eig(K))) - trace(K \ (f_c * f_c'));