% build_effect:
%
% This function takes the fitted parameters of a Gaussian process and
% generates the dose-response curve of a treatment on a outcome. The input
% Gaussian process was fit to observational data, and now we average over
% it going through the same treatment points as in the observational data,
% but independently of adjustment covariates.
%
% Input:
%
% - covfunc, hyp: covariance function and respective hyperparameters
% - x, y: indices of treatment and outcome
% - Z: array of indices of adjustment covariates
%
% Output:
%
% - X_values: values in which we assess the doses
% - y_hat: corresponding expected outcomes

function [X_values, y_hat] = build_effect(covfunc, hyp, dat, x, y, Z)

n = size(dat, 1);
K = feval(covfunc{:}, hyp.cov, dat(:, [x Z])) + eye(n) * exp(hyp.lik)^2;
X_values = sort(dat(:, x));
Z_dat = dat(:, Z);
XZ_dat = [dat(:, x) Z_dat];
Y_dat = dat(:, y);

K_w = K \ Y_dat;

y_hat = zeros(n, 1);
for i = 1:n
  points = [X_values(i) * ones(n, 1) Z_dat];
  Ks = feval(covfunc{:}, hyp.cov, XZ_dat, points);
  y_zhat = Ks' * K_w;
  y_hat(i) = mean(y_zhat);
end
