% batch_synth_run_and_compare:
%
% Compare methods based on the default choice of priors and problems
% generated by 'generate_problems'. To better understand the context of
% this function, please see file "app/demo.m".
%
% Input:
%
% - path_input, path_output: directories where to read the data files from
%                            and where to store the output of the inference;
% - num_Z_sel: number of common causes that will be visible to the
%              algorithm;
% - load_sorted_Z: load a variant of the problem where we explicitly
%                  mention which common causes to keep by sorting them with
%                  a measure of "strength" of the confounding induced.
%                  See "app/demo.m" to understand where this comes from;
% - M, burn_in: number of MCMC samples and burn-in iterations;                 
% - num_total_exps: vector with a set of sample sizes for the
%                    interventional simulations;
% - num_X_space: number of dose levels, to be generated uniformly in the
%                space observed in the observational sample;
% - num_iter: number of optimization steps as used internally to fit
%             hyperparameters of some of the Gaussian process models;
% - verbose: if set 1, shows progress of the method. If set to 2, shows
%            further details at each iteration. Set to 0 for no output.

function batch_synth_run_and_compare(path_input, path_output, ...
           num_Z_sel, load_sorted_Z, M, burn_in, num_total_exps, ...
           num_X_space, num_iter, verbose)

if nargin < 10, verbose = 0; end

names = dir(strcat(path_input, '/problem*.mat'));

for i = 1:length(names)
    
  if verbose > 0
    fprintf('     (PROBLEM %d) Going through file %s\n', i, names(i).name)
  end
  
  file_name = strcat(path_input, '/', names(i).name);  
  load(file_name, 'dat', 'model')
  x = size(dat, 2) - 1; y = size(dat, 2);
  if load_sorted_Z
    fprintf('     Using pre-sorted adversarial setting\n')
    file_name = strcat(path_input, '/Z_sorting_', names(i).name);  
    load(file_name, 'Z_sorted_oracle')
    Z_sorted_oracle = Z_sorted_oracle';    
    file_name_output = strcat(path_output, '/adversarial_result_', names(i).name);
  else
    Z_sorted_oracle = [];
    file_name_output = strcat(path_output, '/result_', names(i).name);
  end
  [X_exp_uniform, Y_exp_uniform, X_space, f_space, model1, model2, model3, model4, model5, ...
     eval_error_space1, eval_error_space2,  eval_error_space3, eval_error_space4, eval_error_space5, ...
     prior_info, do_params_X_space, f_hat_confounded, f_hat_naive_space, ...
     hyper_a, hyper_likv, Z_sorted_oracle, Z_sel] = ...
            synth_run_and_compare(dat, model, num_Z_sel, Z_sorted_oracle, M, burn_in, num_total_exps, num_X_space, num_iter); %#ok<*NASGU,*ASGLU>  
  save(file_name_output, 'X_exp_uniform', 'Y_exp_uniform', 'X_space', 'f_space', ...
        'model1', 'model2', 'model3', 'model4', 'model5', ...
        'eval_error_space1', 'eval_error_space2', 'eval_error_space3', 'eval_error_space4', 'eval_error_space5', ...
        'prior_info', 'do_params_X_space', 'f_hat_confounded', 'f_hat_naive_space', ...
        'hyper_a', 'hyper_likv', ...
        'num_Z_sel', 'M', 'burn_in', 'num_total_exps', 'num_iter', ...
        'Z_sorted_oracle', 'Z_sel', 'x', 'y')
    
end
