% batch_summarize_results:
%
% Compare methods based on the default choice of priors and problems
% generated by 'generate_problems'.
%
% Input:
%
% - path_input, path_output: paths where to find problem definitions and
%                            results;
% - load_sorted_Z: flag indicating whether it is an adversarial or random
%                  setting;
%
% Output:
%
% - mean_fact..., llik_fact...: mean absolute error and log-likelihood fits

function [mean_fact, mean_notaff, mean_defa, mean_plain, mean_smadd, mean_conf, ...
          llik_fact, llik_notaff, llik_defa, llik_plain, llik_smadd] = ...
          batch_summarize_results(path_input, path_output, load_sorted_Z)

names = dir(strcat(path_input, '/problem*.mat'));
if load_sorted_Z
  num_problems = length(dir(strcat(path_output, '/adversarial_result*.mat')));
else
  num_problems = length(dir(strcat(path_output, '/result*.mat')));
end

mean_fact   = zeros(num_problems, 3);
mean_notaff = zeros(num_problems, 3);
mean_defa   = zeros(num_problems, 3);
mean_plain  = zeros(num_problems, 3);
mean_smadd  = zeros(num_problems, 3);
mean_conf   = zeros(num_problems, 3);
llik_fact   = zeros(num_problems, 3);
llik_notaff = zeros(num_problems, 3);
llik_defa   = zeros(num_problems, 3);      
llik_plain  = zeros(num_problems, 3);
llik_smadd  = zeros(num_problems, 3);

for i = 1:num_problems

  file_name = strcat(path_input, '/', names(i).name);  
  load(file_name, 'dat', 'model')
  if load_sorted_Z
    file_name_output = strcat(path_output, '/adversarial_result_', names(i).name);
  else
    file_name_output = strcat(path_output, '/result_', names(i).name);
  end
  load(file_name_output)       

  num_exps = length(num_total_exps);

  for v = 1:num_exps

    f_fact = model1{v}.a(:, burn_in + 1:end) .* model1{v}.f_obs(:, burn_in + 1:end) + model1{v}.b(:, burn_in + 1:end); %#ok<*USENS>
    mean_method = mean(f_fact, 2);
    var_method = var(f_fact, [], 2);
    llik_fact(i, v) = -0.5 * (log(sqrt(2 * pi)) + mean(log(var_method)) + mean((f_space - mean_method).^2 ./ var_method));          
    mean_fact(i, v) = mean(abs(f_space - mean_method));

    f_single = model2{v}.f_obs(:, burn_in + 1:end);
    mean_method = mean(f_single, 2);
    var_method = var(f_single, [], 2);
    llik_notaff(i, v) = -0.5 * (log(sqrt(2 * pi)) + mean(log(var_method)) + mean((f_space - mean_method).^2 ./ var_method));          
    mean_notaff(i, v) = mean(abs(f_space - mean_method));

    f_smadd = model3{v}.f(:, burn_in + 1:end);
    mean_method = mean(f_smadd, 2);
    var_method = var(f_smadd, [], 2);
    llik_smadd(i, v) = -0.5 * (log(sqrt(2 * pi)) + mean(log(var_method)) + mean((f_space - mean_method).^2 ./ var_method));          
    mean_smadd(i, v) = mean(abs(f_space - mean_method));

    mean_method = model4{v}.f';
    var_method = diag(model4{v}.cov_f);
    mean_defa(i, v) = mean(abs(f_space - mean_method));
    llik_defa(i, v) = -0.5 * (log(sqrt(2 * pi)) + mean(log(var_method)) + mean((f_space - mean_method).^2 ./ var_method));

    mean_method = model5{v}.f';
    var_method = diag(model5{v}.cov_f);
    mean_plain(i, v) = mean(abs(f_space - mean_method));
    llik_plain(i, v) = -0.5 * (log(sqrt(2 * pi)) + mean(log(var_method)) + mean((f_space - mean_method).^2 ./ var_method));

    mean_conf(i, v) = mean(abs(f_space - f_hat_confounded{2}));

  end

end

ch = ' *';
fprintf('Mean abs NotAff  - Affine    :   ')      
pass = ttest(mean_notaff - mean_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(mean_notaff(:, v) - mean_fact(:, v)), ch(pass(v) + 1)); end; fprintf('\n')            
fprintf('Mean abs Default - Affine    :   ')      
pass = ttest(mean_defa - mean_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(mean_defa(:, v) - mean_fact(:, v)), ch(pass(v) + 1)); end; fprintf('\n')      
fprintf('Mean abs Plain   - Affine    :   ')      
pass = ttest(mean_plain - mean_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(mean_plain(:, v) - mean_fact(:, v)), ch(pass(v) + 1)); end; fprintf('\n')      
fprintf('Mean abs SmAdd   - Affine    :   ')      
pass = ttest(mean_smadd - mean_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(mean_smadd(:, v) - mean_fact(:, v)), ch(pass(v) + 1)); end; fprintf('\n')      
fprintf('\n')
fprintf('Mean abs Confounded - Affine :   ')      
pass = ttest(mean_plain - mean_conf);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(mean_conf(:, v) - mean_fact(:, v)), ch(pass(v) + 1)); end; fprintf('\n')      
fprintf('\n')
fprintf('Llik Affine - NotAff         :   ')
pass = ttest(llik_notaff - llik_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(llik_fact(:, v) - llik_notaff(:, v)), ch(pass(v) + 1)); end; fprintf('\n')
fprintf('Llik Affine - Default        :   ')
pass = ttest(llik_defa - llik_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(llik_fact(:, v) - llik_defa(:, v)), ch(pass(v) + 1)); end; fprintf('\n')
fprintf('Llik Affine - Plain          :   ')
pass = ttest(llik_plain - llik_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(llik_fact(:, v) - llik_plain(:, v)), ch(pass(v) + 1)); end; fprintf('\n')
fprintf('Llik Affine - SmAdd          :   ')
pass = ttest(llik_smadd - llik_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(llik_fact(:, v) - llik_smadd(:, v)), ch(pass(v) + 1)); end; fprintf('\n')
fprintf('\n')
fprintf('Mean abs Affine < NotAff     :   ')
for v = 1:num_exps, pass(v) = signtest(mean_notaff(:, v) - mean_fact(:, v)) <= 0.05; end
for v = 1:num_exps, fprintf('  %.2f%s', mean(mean_fact(:, v) < mean_notaff(:, v)), ch(pass(v) + 1)); end; fprintf('\n')      
fprintf('Mean abs Affine < Default    :   ')
for v = 1:num_exps, pass(v) = signtest(mean_defa(:, v) - mean_fact(:, v)) <= 0.05; end
for v = 1:num_exps, fprintf('  %.2f%s', mean(mean_fact(:, v) < mean_defa(:, v)), ch(pass(v) + 1)); end; fprintf('\n')      
fprintf('Mean abs Affine < Plain      :   ')
for v = 1:num_exps, pass(v) = signtest(mean_plain(:, v) - mean_fact(:, v)) <= 0.05; end
for v = 1:num_exps, fprintf('  %.2f%s', mean(mean_fact(:, v) < mean_plain(:, v)), ch(pass(v) + 1)); end; fprintf('\n')      
fprintf('Mean abs Affine < SmAdd      :   ')      
pass = ttest(mean_smadd - mean_fact);
for v = 1:num_exps, fprintf(' %+.2f%s', mean(mean_fact(:, v) < mean_smadd(:, v)), ch(pass(v) + 1)); end; fprintf('\n')      
fprintf('\n')
fprintf('Llik Affine > NotAff         :   ')
for v = 1:num_exps, pass(v) = signtest(llik_notaff(:, v) - llik_fact(:, v)) <= 0.05; end
for v = 1:num_exps, fprintf('  %.2f%s', mean(llik_fact(:, v) > llik_notaff(:, v)), ch(pass(v) + 1)); end; fprintf('\n')
fprintf('Llik Affine > Default        :   ')
for v = 1:num_exps, pass(v) = signtest(llik_defa(:, v) - llik_fact(:, v)) <= 0.05; end
for v = 1:num_exps, fprintf('  %.2f%s', mean(llik_fact(:, v) > llik_defa(:, v)), ch(pass(v) + 1)); end; fprintf('\n')
fprintf('Llik Affine > Plain          :   ')
for v = 1:num_exps, pass(v) = signtest(llik_plain(:, v) - llik_fact(:, v)) <= 0.05; end
for v = 1:num_exps, fprintf('  %.2f%s', mean(llik_fact(:, v) > llik_plain(:, v)), ch(pass(v) + 1)); end; fprintf('\n')
fprintf('Llik Affine > SmAdd          :   ')
for v = 1:num_exps, pass(v) = signtest(llik_smadd(:, v) - llik_fact(:, v)) <= 0.05; end
for v = 1:num_exps, fprintf('  %.2f%s', mean(llik_fact(:, v) > llik_smadd(:, v)), ch(pass(v) + 1)); end; fprintf('\n')
fprintf('\n')

