% assess_methods:
%
% Provide summary of the method given past experiments (X_train, Y_train)
% and a set of locations for testing.

function eval_error = assess_methods(predict_samples_space, prior_mean, ...
                                     f_hat_direct, f_hat_confounded, ...
                                     X_test, f_test, X_obs, visualize, ...
                                     verbose)

if nargin < 9, verbose = false; end

f_hat_bayes = mean(predict_samples_space)';

scale = max(f_test) - min(f_test);

if visualize
    
  %min_point = min([f_test; f_hat_bayes; f_hat_direct]);  
  
  figure; plot(X_test, predict_samples_space', 'Color', [0.4,0.4,0.4]); hold on
  plot(X_test, f_test, '-g', 'LineWidth', 5)
  plot(X_test, f_hat_bayes, '-b', 'LineWidth', 5);
  plot(X_test, f_hat_direct{2}, '-r', 'LineWidth', 5)
  %plot(X_obs, min_point - 0.1, 'o', 'Color', [0.4,0.4,0.4])
  plot(X_test, f_hat_confounded{2}, '--m', 'LineWidth', 5)
  if ~isempty(prior_mean)
    plot(X_test, prior_mean, '--b', 'LineWidth', 5)
  end
  title('Inference'); hold off
  
end

bayes_err1 = assess_estimate_empirical(X_test, X_obs, f_hat_bayes, f_test) / scale;
bayes_err2 = mean(abs(f_hat_bayes - f_test)) / scale;
if verbose, fprintf('Bayes error                : [%.3f %.3f]\n', bayes_err1, bayes_err2); end

if ~isempty(prior_mean)
  prior_err1 = assess_estimate_empirical(X_test, X_obs, prior_mean, f_test) / scale;
  prior_err2 = mean(abs(prior_mean - f_test)) / scale;
  if verbose, fprintf('Prior error                : [%.3f %.3f]\n', prior_err1, prior_err2); end
else
  prior_err1 = 0;
  prior_err2 = 0;
end

num_direct = length(f_hat_direct);
direct_err1 = cell(num_direct, 1);
direct_err2 = cell(num_direct, 1);
for d = 1:num_direct
  direct_err1{d} = assess_estimate_empirical(X_test, X_obs, f_hat_direct{d}, f_test) / scale;
  direct_err2{d} = mean(abs(f_hat_direct{d} - f_test)) / scale;
  if verbose, fprintf('Direct error %d             : [%.3f %.3f]\n', d, direct_err1{d}, direct_err2{d}); end
end

num_confounded = length(f_hat_confounded);
confounded_err1 = cell(num_confounded, 1);
confounded_err2 = cell(num_confounded, 1);
for d = 1:num_confounded
  confounded_err1{d} = assess_estimate_empirical(X_test, X_obs, f_hat_confounded{d}, f_test) / scale;
  confounded_err2{d} = mean(abs(f_hat_confounded{d} - f_test)) / scale;
  if verbose, fprintf('Direct error %d (confounded): [%.3f %.3f]\n', d, confounded_err1{d}, confounded_err2{d}); end
end
if verbose, fprintf('\n'); end

eval_error.bayes_err1 = bayes_err1;
eval_error.bayes_err2 = bayes_err2;
eval_error.prior_err1 = prior_err1;
eval_error.prior_err2 = prior_err2;
eval_error.direct_err1 = direct_err1;
eval_error.direct_err2 = direct_err2;
eval_error.confounded_err21 = confounded_err1;
eval_error.confounded_err22 = confounded_err2;

% Evaluate log-likelihood

var_bayes = var(predict_samples_space)';
eval_error.llik_bayes = -0.5 * (log(sqrt(2 * pi)) + mean(log(var_bayes)) + mean((f_test - f_hat_bayes).^2 ./ var_bayes));
var_bayes = var(predict_samples_space)';
eval_error.llik_bayes = -0.5 * (log(sqrt(2 * pi)) + mean(log(var_bayes)) + mean((f_test - f_hat_bayes).^2 ./ var_bayes));
if verbose, fprintf('Bayes approx. llik         : [%.3f]\n', eval_error.llik_bayes); end

if verbose, fprintf('\n'); end

