% assess_estimate_empirical:
%
% Used by 'assess_methods'. Provides error weigthed by the empirical
% distribution given by X_obs, binned according to the evaluation points
% given by X_grid.

function error = assess_estimate_empirical(X_grid, X_obs, f_hat, true_f)

[X_grid, idx] = sort(X_grid);
n = length(X_grid);

grid_thresh = ([0; X_grid(2:n)] + [X_grid(1:(n - 1)); 0]) / 2;
grid_thresh(1) = -Inf;
grid_thresh(end) = Inf;

grid_prob = zeros(n, 1);
for i = 2:n
  grid_prob(i) = sum(X_obs <= grid_thresh(i)) - sum(X_obs <= grid_thresh(i - 1));
end
grid_prob = grid_prob + 1;
grid_prob = grid_prob / sum(grid_prob);

error = abs(f_hat(idx) - true_f(idx))' * grid_prob;