% search_info_gain_strata:
%
% Find point to perform experiment. Essentially looks for point (across
% strata) of largest posterior variance.
%
% Input:
%
% - a, b: samples from distortion/translation functions;
% - f_obs: samples of observational function.
%
% Output:
%
% - new_idx: position of new experiment in dose space;
% - new_s: which stratum to sample from.

function [new_idx, new_s] = search_info_gain_strata(a, b, f_obs)

[num_X_space, M] = size(a{1});
S = length(f_obs);

E_y  = zeros(num_X_space, S);
E_y2 = zeros(num_X_space, S);

for m = 1:M
  for s = 1:S
    mu = a{s}(:, m) .* f_obs{s}(:, m) + b{s}(:, m);
    E_y(:, s) = E_y(:, s) + mu;
    E_y2(:, s) = E_y2(:, s) + mu.^2;
  end
end

E_y = E_y / M;
E_y2 = E_y2 / M;
var_pred = E_y2 - E_y.^2;

[val_X, X_max] = max(var_pred);
[~, new_s] = max(val_X);
new_idx = X_max(new_s);
